//FloorMagnetRecessess.scad;

include <BATT_Dimensions.scad>
use <BATT_FloorMagnetRecess.scad>;

//Use FloorMagnetRecess two times to generate 
//two magnet recesses;

//FloorMagnetRecess generates one magnet 
//recess centered at the origin 
//and the XY plane;
//Its height is not MagnetHoleHeight, 
//but 2*MagnetHoleHeight;
//It will extend MagnetHoleHeight below 
//the XY plane and MagnetHoleHeight 
//above it;
//When translated by DeltaZ = FloorZ,
//it will make a recess MagnetHoleHeight 
//deep into the top of FloorOne;
//When translated by DeltaZ = 0,
//it will make a recess MagnetHoleHeight 
//deep into the bottom of FloorTwo;
    
//On exit from this module, 
//each recess is a small cylinder;
//It doesn't become a recess until it is used 
//as the second argument of a 
//difference() command;

//The recesses are all the same size;

module FloorMagnetRecesses()
{

echo("Begin FloorMagnetRecesses");

//DeltaZ is constant for all recesses;
DeltaZ = FloorZ;

//One of MagnetDeltaX or MagnetDeltaY 
//will be zero and the magnet recesses 
//will be on an X or Y centerline, 
//not on a diagonal;
    
//Two recesses for two magnets;
translate([MagnetHoleDeltaX, 
    MagnetHoleDeltaY, DeltaZ])
    FloorMagnetRecess();

translate([-MagnetHoleDeltaX, 
    -MagnetHoleDeltaY, DeltaZ])
    FloorMagnetRecess();

}
//
